/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.language;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class LanguageDisplayFactory {
    private static Language currentSelectedLanguage;
    private static Map<String, String> commonDisplayMessages;

    public static Map<String, String> getDisplayMessages(Class<?> clazz, Language language) {
        if (!language.equals(currentSelectedLanguage)) {
            commonDisplayMessages = LanguageDisplayFactory.getDisplayMessages("Common_" + language.getLocaleName().toString() + ".properties");
            currentSelectedLanguage = language;
        }
        Map<String, String> specificClassPropertiesMap = LanguageDisplayFactory.getDisplayMessages(clazz.getSimpleName() + "_" + language.getLocaleName().toString() + ".properties");
        HashMap<String, String> completeMessagesMap = new HashMap<String, String>(commonDisplayMessages);
        completeMessagesMap.putAll(specificClassPropertiesMap);
        return Collections.unmodifiableMap(completeMessagesMap);
    }

    private static Map<String, String> getDisplayMessages(String propertiesString) {
        Properties properties = new Properties();
        try {
            InputStream stream = LanguageDisplayFactory.class.getResourceAsStream(propertiesString);
            Object object = null;
            try {
                properties.load(stream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException stream) {
            // empty catch block
        }
        HashMap<String, String> displayMessages = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            displayMessages.put(name, properties.getProperty(name));
        }
        return displayMessages;
    }

    static {
        commonDisplayMessages = null;
    }
}

